## Orignal Macros copied from lighttpd 2.0

## modules are without the "lib" prefix

macro(setup_static_modules TARGET)
	file(WRITE ${TARGET}_builtins.h "/* auto-generated by CMake build do not edit */\n\n")
endmacro(setup_static_modules)

macro(add_module TARGET MODNAME)
	set(_static_mod ${BUILD_STATIC})

	## create list of module source files.
	set(_srcfiles)
	set(_def_module_src ${CMAKE_CURRENT_SOURCE_DIR}/modules/${MODNAME}.c)
	if(EXISTS ${_def_module_src})
		set(_srcfiles ${_def_module_src})
	endif(EXISTS ${_def_module_src})
	foreach(_srcfile ${ARGN})
		if(_srcfile STREQUAL "STATIC")
			set(_static_mod TRUE)
		else(_srcfile STREQUAL "STATIC")
			set(_srcfiles ${_srcfiles} ${_srcfile})
		endif(_srcfile STREQUAL "STATIC")
	endforeach(_srcfile)

	if(_static_mod)
		set(STATIC_MODULE_SRC ${STATIC_MODULE_SRC} ${_srcfiles})
		file(APPEND ${TARGET}_builtins.h "STATIC_MOD(${MODNAME})\n")
	else(_static_mod)
		add_library(${MODNAME} MODULE ${_srcfiles})
		set(MODULE_TARGETS ${MODULE_TARGETS} ${MODNAME})

		add_target_properties(${MODNAME} LINK_FLAGS ${COMMON_LDFLAGS})
		add_target_properties(${MODNAME} COMPILE_FLAGS ${COMMON_CFLAGS})
		set_target_properties(${MODNAME} PROPERTIES CMAKE_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX})

		## Windows likes to link it this way back to app!
		if(WIN32)
			set_target_properties(${MODNAME} PROPERTIES LINK_FLAGS ${TARGET}.lib)
		endif(WIN32)

		if(APPLE)
			set_target_properties(${MODNAME} PROPERTIES LINK_FLAGS "-flat_namespace -undefined suppress")
		endif(APPLE)
	endif(_static_mod)
endmacro(add_module)

macro(add_target_properties _target _name)
	set(_properties)
	foreach(_prop ${ARGN})
		set(_properties "${_properties} ${_prop}")
	endforeach(_prop)
	get_target_property(_old_properties ${_target} ${_name})
	##message(STATUS "adding property to ${_target} ${_name}:" ${_properties})
	if(NOT _old_properties)
		# in case it's NOTFOUND
		set(_old_properties)
	endif(NOT _old_properties)
	set_target_properties(${_target} PROPERTIES ${_name} "${_old_properties} ${_properties}")
endmacro(add_target_properties)

